<?php declare(strict_types = 1);

namespace EshopCheckout\DI;

use Core\DI\CompilerExtension;
use Nette;

class EshopCheckoutExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopCheckout' => 'EshopCheckout\*Module\Presenters\*Presenter']);
	}

}
