import {categories, products} from "../data/data";
import axios from 'axios';

const eshopCatalogBase = '/api/v1/eshopcatalog/';
const eshopOrdersBase = '/api/v1/eshoporders/';



export const fetchProductsFromCategory = async (categoryId = null) => {
	const products = await axios.get(`${eshopCatalogBase}/category/${categoryId}/products`);
	console.log(products);
	return products.data.data;
};

export const searchProducts = async (parameter = "") => {
	return products.filter((p) => (p.name = parameter));
};

export const getCategories = async () => {
	const categories = await axios.get(`${eshopCatalogBase}/category`);
	console.log(categories);
	return categories.data.data;
};