// import {axios} from "./axiosWrapper";
import axios from "axios";

const eshopCatalogBase = '/api/v1/eshopcatalog';
const eshopOrdersBase  = '/api/v1/eshoporders';
const eshopSalesBase   = '/api/v1/eshopsales';
const eshopCheckoutBase   = '/api/v1/eshopcheckout';

const authString = 'Basic UFNIS0NNUzo4dHRONUF3MFh3bjYwTm0j';

export const fetchProductsFromCategory = async (categoryId = null) => {
	const products = await axios.get(`${eshopCatalogBase}/category/${categoryId}/products`);
	return products.data.data;
};

export const searchProducts = async (term = "", userId = null) => {
	if (typeof global.cancelToken != typeof undefined) {
		global.cancelToken.cancel("Operation canceled due to new request.");
	}
	global.cancelToken = axios.CancelToken.source();

	let items = [];
	try {
		global.checkout.$emit('searchingStart')
		await axios.get(`${eshopCatalogBase}/product/search/${term}`, {
			cancelToken: global.cancelToken.token,
			params: {userId}
		}).then(function (response) {
			global.checkout.$emit('searchingStop')
			items = response.data.data
		})
	} catch (error) {
	}

	return items;
};

export const searchProductByCode = async (term = "", userId = null) => {
	if (typeof global.cancelToken != typeof undefined) {
		global.cancelToken.cancel("Operation canceled due to new request.");
	}
	global.cancelToken = axios.CancelToken.source();

	let item = null;
	try {
		await axios.get(`${eshopCatalogBase}/product/searchByCode/${term}`, {
			cancelToken: global.cancelToken.token,
			params: {userId}
		}).then(function (response) {
			item = response.data.data
		})
	} catch (error) {
	}

	return item;
};

export const getCategories = async () => {
	const categories = await axios.get(`${eshopCatalogBase}/category`);
	return categories.data.data;
};

export const createOrder = async (checkoutProducts, globalSales, payment, spedition, customer, totalPrice, transactionId, orderId) => {
	const result = await axios.post(`${eshopOrdersBase}/orders/create`, {
		checkoutProducts,
		globalSales,
		payment,
		spedition,
		customer,
		totalPrice,
		transactionId,
		orderId
	}, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true
		}
	}).catch(response => {
		return {
			error: true
		}
	});

	return result;
};

export const getCustomersInGroup = async () => {
	const result = await axios.get(`${eshopOrdersBase}/customers/in-group`, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true
		}
	}).catch(response => {
		return {
			error: true
		}
	});

	return result;
}

export const getOrder = async (id) => {
	const result = await axios.get(`${eshopOrdersBase}/orders/${id}`, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true,
			message: response.data.message
		}
	}).catch(error => {
		return {
			error: true,
			message: error.response.data.data.message
		};
	});

	return result
}

export const checkDiscountCodeValidity = async (code, totalPrice) => {
	const result = await axios.post(`${eshopSalesBase}/sales/check-discount-code-validity`, {
		code,
		totalPrice
	})
	return result.data
}

export const getTerminals = async () => {
	const result = await axios.get(`${eshopCheckoutBase}/terminals/get-all`)
	return result.data.data
}

export const setActiveTerminal = async (terminalId) => {
	const result = await axios.post(`${eshopCheckoutBase}/terminals/set-active-terminal`, {terminalId})
	return result.data.data
}

export const removeTerminal = async (terminalId) => {
	const result = await axios.post(`${eshopCheckoutBase}/terminals/remove`, {terminalId})
	return result.data.data
}

export const saveTerminal = async (terminal) => {
	const result = await axios.post(`${eshopCheckoutBase}/terminals/save`, {...terminal})
	return result.data.data
}