import axios from 'axios'

const nexgoTerminalConf = {
	currencyCode: '203',
	daughterCompanyId: ''
}

export default class NexgoTerminalApi
{
	constructor(ip, port, secureString) {
		this.ip = ip
		this.port = port
		this.secureString = secureString
	}

	_url() {
		return `http://${this.ip}:${this.port}`
	}

	async isNexgoTerminalOnline()
	{
		let isOnline = true

		try {
			const response = await axios.post(`${this._url()}/paya/terminal`, {
					'secureString': this.secureString,
					'checkOnline': true
				}, {timeout: 3500, timeoutErrorMessage: 'timeout'}
			)

			if (response.status !== 200) {
				return false
			}

			if (response.data.isOnline === 2) {
				return false
			}

			return true

		} catch (e) {
			if (e.code === 'ECONNABORTED') {
				return false
			} else {
				throw e
			}
		}
	}

	async createPaymentNexgoTerminal(transactionId, amount) {
		return await axios.post(`${this._url()}/paya/payment`, {
				'secureString': this.secureString,
				'request': {
					'amount': amount * 100,
					'currencyCode': '203',
					'invoiceNumber': '',
					'transactionId': transactionId,
					'daughterCompanyId': ''
				}
			}
		)
	}

	async checkPaymentStatusNexgoTerminal(transactionId) {
		return await axios.post(`${this._url()}/paya/status`, {
				'transactionId': transactionId,
				'secureString': this.secureString
			}
		)
	}

	async getPaymentResult(transactionId) {
		return await axios.post(`${this._url()}/paya/result`, {
				'transactionId': transactionId,
				'secureString': this.secureString
			}
		)
	}

	async confirmPayment(transactionId) {
		return await axios.post(`${this._url()}/paya/confirm`, {
				'transactionId': transactionId,
				'secureString': this.secureString,
				'confirm': true
			}
		)
	}

	async getInfo() {
		return await axios.get(`${this._url()}/paya/info`)
	}

}