<?php declare(strict_types = 1);

namespace EshopCheckout\AdminModule\Model\Statistics;

use EshopOrders\Model\Entities\Order;
use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\Model\Entities\OrderStatus;
use EshopOrders\AdminModule\Model\Statistics\Statistics as EshopOrdersStatistics;

class Statistics
{
	protected EntityManagerDecorator $em;
	protected EshopOrdersStatistics $eshopOrdersStats;

	public function __construct(EntityManagerDecorator $em, EshopOrdersStatistics $eshopOrdersStats)
	{
		$this->em               = $em;
		$this->eshopOrdersStats = $eshopOrdersStats;
	}

	public function getTodayStore(): array
	{
		$result = [
			'checkout' => [
				'storeCard' => [
					'price' => 0,
					'count' => 0,
				],
				'storeCash' => [
					'price' => 0,
					'count' => 0,
				],
			],
			'pickup'   => [
				'card'  => [
					'price' => 0,
					'count' => 0,
				],
				'store' => [
					'price' => 0,
					'count' => 0,
				],
			],
		];

		$canceled = $this->eshopOrdersStats->getTodayStatusIds(OrderStatus::STATUS_CANCELED);
		foreach ($this->eshopOrdersStats->getTodayCreated() as $order) {
			if (isset($canceled[$order->getId()])) {
				continue;
			}

			if (in_array($order->getPaymentIdent(), ['storeCard', 'storeCash'])) {
				$result['checkout'][$order->getPaymentIdent()]['price'] += $order->getPrice() - $order->getPaySpedPrice();
				$result['checkout'][$order->getPaymentIdent()]['count']++;
			}
		}

		$todayDone = $this->eshopOrdersStats->getTodayStatusIds(OrderStatus::STATUS_FINISHED);
		foreach ($this->eshopOrdersStats->getBaseQueryBuilder()
			         ->andWhere('o.id IN (:ids)')
			         ->setParameters([
				         'ids' => array_keys($todayDone),
			         ])->getQuery()->getResult() as $order) {
			/** @var Order $order */
			if ($order->getSpeditionIdent() !== 'pickup' || $order->site->getIdent() === 'don') {
				continue;
			}

			$result['pickup'][$order->getPaymentIdent()]['price'] += $order->getPrice() - $order->getPaySpedPrice();
			$result['pickup'][$order->getPaymentIdent()]['count']++;
		}

		return $result;
	}
}
