<?php declare(strict_types = 1);

namespace EshopCheckout\AdminModule\Presenters;

use EshopCheckout\Model\Builders\IOrderReceiptBuilderFactory;
use EshopOrders\AdminModule\Model\Orders;
use Nette\Application\BadRequestException;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	/** @var IOrderReceiptBuilderFactory @inject */
	public IOrderReceiptBuilderFactory $orderReceiptBuilderFactory;

	/** @var Orders @inject */
	public Orders $orders;

	/**
	 * @param mixed $element
	 * @throws BadRequestException
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);

		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access')) {
			$this->error();
		}

	}
}
