<?php declare(strict_types = 1);

namespace EshopCheckout\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;

class EshopCheckoutExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopCheckout' => 'EshopCheckout\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods['initialize'];
		$builder = $this->getContainerBuilder();

		$init->addBody('EshopCheckout\Model\EshopCheckoutConfig::setParams(?);', [$builder->parameters['eshopCheckout']]);
	}

}
