<?php declare(strict_types=1);

namespace EshopCheckout\Model\Events;

use Core\Model\Templating\Template;
use EshopOrders\Model\Entities\Order;
use Symfony\Contracts\EventDispatcher\Event;

class OrderReceiptRenderEvent extends Event
{
	public Template $template;
	public Order $order;

	public function __construct(Template $template, Order $order)
	{
		$this->template = $template;
		$this->order = $order;
	}

}