<?php declare(strict_types = 1);

namespace EshopCheckout\AdminModule\Model\Statistics;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Query\Parameter;
use EshopOrders\AdminModule\Model\Statistics\Statistics as EshopOrdersStatistics;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;

class Statistics
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected EshopOrdersStatistics  $eshopOrdersStats,
	)
	{
	}

	public function getTodayStore(): array
	{
		$result = [
			'checkout' => [
				'storeCard' => [
					'price' => 0,
					'count' => 0,
				],
				'storeCash' => [
					'price' => 0,
					'count' => 0,
				],
			],
			'pickup'   => [
				'card'  => [
					'price' => 0,
					'count' => 0,
				],
				'store' => [
					'price' => 0,
					'count' => 0,
				],
			],
		];

		$canceled = $this->eshopOrdersStats->getTodayStatusIds(OrderStatus::STATUS_CANCELED);

		$todayDone = $this->eshopOrdersStats->getTodayStatusIds(OrderStatus::STATUS_FINISHED);
		foreach ((array) $this->eshopOrdersStats->getBaseQueryBuilder()
			->andWhere('o.id IN (:ids)')
			->setParameters(new ArrayCollection([
				new Parameter('ids', array_diff(array_keys($todayDone), array_keys($canceled))),
			]))
			->groupBy('o.id')
			->getQuery()->getResult() as $order) {
			/** @var Order $order */
			if ($order->getParam('origin') === 'eshopcheckout') {
				$result['checkout'][$order->getPaymentIdent()]['price'] += $order->getPrice();

				$result['checkout'][$order->getPaymentIdent()]['count'] ??= 0;
				$result['checkout'][$order->getPaymentIdent()]['count']++;
			} else {
				if ($order->getSpeditionIdent() !== 'pickup' || ($order->site && $order->site->getIdent() === 'don')) {
					continue;
				}

				$paymentIdent = $order->getPaymentIdent();
				switch ($paymentIdent) {
					case 'storeCard':
						$paymentIdent = 'card';
						break;
					case 'storeCash':
						$paymentIdent = 'store';
						break;
				}

				$result['pickup'][$paymentIdent]['price'] += $order->getPrice();

				$result['pickup'][$paymentIdent]['count'] ??= 0;
				$result['pickup'][$paymentIdent]['count']++;
			}
		}

		return $result;
	}
}
