<?php declare(strict_types = 1);

namespace EshopCheckout\AdminModule\Presenters;

use EshopCheckout\Model\Builders\IOrderReceiptBuilderFactory;
use EshopOrders\AdminModule\Model\Orders;
use Nette\Application\BadRequestException;
use Nette\Application\UI\ComponentReflection;
use Nette\DI\Attributes\Inject;
use Override;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	#[Inject]
	public IOrderReceiptBuilderFactory $orderReceiptBuilderFactory;

	#[Inject]
	public Orders $orders;

	/**
	 * @param ComponentReflection $element
	 *
	 * @throws BadRequestException
	 */
	#[Override]
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);

		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access')) {
			$this->error();
		}
	}
}
