<?php declare(strict_types = 1);

namespace EshopCheckout\ApiModule\Api\V1\Model;

use Core\Model\Entities\EntityManagerDecorator;
use EshopCheckout\Model\Entities\Terminal;
use Exception;
use Tracy\Debugger;

class Terminals
{
	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	public function getAllAssoc(): array
	{
		$qb = $this->em->getRepository(Terminal::class)->createQueryBuilder('t');
		$qb->select('t.id, t.ip, t.port, t.secureString, t.terminalId, t.isActive')
			->orderBy('t.terminalId');

		return $qb->getQuery()->getArrayResult();
	}

	public function setActive(int $id): bool
	{
		try {
			$this->em->beginTransaction();
			$er = $this->em->getRepository(Terminal::class);
			$er->createQueryBuilder('t')->update()
				->set('t.isActive', 0)
				->getQuery()->execute();

			$er->createQueryBuilder('t')->update()
				->set('t.isActive', 1)
				->where('t.id = :id')
				->setParameter('id', $id)
				->getQuery()->execute();

			$this->em->commit();

			return true;
		} catch (Exception $e) {
			Debugger::log($e);
			if ($this->em->getConnection()->isTransactionActive()) {
				$this->em->rollback();
			}

			return false;
		}
	}

	public function remove(int $id): bool
	{
		try {
			$entity = $this->em->getReference(Terminal::class, $id);

			if (!$entity instanceof Terminal) {
				return false;
			}

			$this->em->remove($entity);
			$this->em->flush();

			return true;
		} catch (Exception $e) {
			Debugger::log($e);

			return false;
		}
	}

}
