<?php declare(strict_types = 1);

namespace EshopCheckout\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

final class Version20200915073909 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		$position = $this->connection->fetchOne('SELECT MAX(position) as max_position FROM eshop_orders__payment');

		if ($position === false || !is_numeric($position)) {
			return;
		}

		$position = (int) $position;

		$this->addSql("INSERT INTO eshop_orders__payment (`name`, is_published, price, `position`, text, available_from, available_to, image, ident, free_from) VALUES ('Na prodejně kartou', '1', '0', :position, '', '0', '9999999', '', 'storeCard', '0')", ['position' => $position + 1]);
		$this->addSql("INSERT INTO eshop_orders__payment (`name`, is_published, price, `position`, text, available_from, available_to, image, ident, free_from) VALUES ('Na prodejně hotově', '1', '0', :position, '', '0', '9999999', '', 'storeCash', '0')", ['position' => $position + 2]);
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql("DELETE FROM eshop_orders__payment WHERE ident IN ('storeCard', 'storeCash')");
	}
}
