<?php declare(strict_types = 1);

namespace EshopCheckout\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

final class Version20230222181444 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_checkout__terminal (id INT AUTO_INCREMENT NOT NULL, ip VARCHAR(255) NOT NULL, port VARCHAR(255) NOT NULL, secure_string VARCHAR(255) NOT NULL, terminal_id VARCHAR(255) NOT NULL, is_active SMALLINT DEFAULT 0 NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_checkout__transaction (order_id INT NOT NULL, trasaction_id VARCHAR(255) NOT NULL, PRIMARY KEY(order_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_checkout__transaction ADD CONSTRAINT FK_8144B9A98D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id) ON DELETE CASCADE');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE eshop_checkout__terminal');
		$this->addSql('DROP TABLE eshop_checkout__transaction');
	}
}
