<?php declare(strict_types = 1);

namespace EshopCheckout\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Order;

#[ORM\Entity]
#[ORM\Table('eshop_checkout__transaction')]
class Transaction
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Order::class)]
	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected Order $order;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	protected string $trasactionId;

	public function __construct(Order $order, string $trasactionId)
	{
		$this->order        = $order;
		$this->trasactionId = $trasactionId;
	}
}
