<?php declare(strict_types = 1);

namespace EshopCheckout\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\UI\DataGrid\BaseDataGrid;
use EshopOrders\AdminModule\Components\Order\OrdersGrid;
use EshopOrders\Model\Entities\Order;
use Nette\Application\LinkGenerator;
use Nette\Utils\Html;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrdersSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected LinkGenerator $linkGenerator,
	)
	{
	}

	/**
	 * @return string[]
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			OrdersGrid::class . '::onAttach' => 'ordersGridAttached',
		];
	}

	public function ordersGridAttached(ControlEvent $event): void
	{
		/** @var BaseDataGrid $grid */
		$grid = $event->control['grid'];

		$grid->addAction('receipt', '')->setRenderer(function(Order $order) {
			if (!in_array($order->getPaymentIdent(), ['storeCash', 'storeCard']) || $order->isCorrectiveTaxDocument || $order->getInvoice()) {
				return '';
			}

			return Html::el('a', [
				'href'   => $this->linkGenerator->link('EshopCheckout:Admin:OrderReceipts:Receipt', ['orderId' => $order->getId()]),
				'class'  => 'btn btn-success btn-xs',
				'target' => '_blank',
			])->addHtml(Html::el('i', ['class' => 'fas fa-file-invoice-dollar']));
		});
	}

}
