// import {axios} from "./axiosWrapper";
import axios from "axios";

const eshopCatalogBase = '/api/v1/eshopcatalog';
const eshopOrdersBase  = '/api/v1/eshoporders';
const eshopSalesBase   = '/api/v1/eshopsales';
const eshopCheckoutBase   = '/api/v1/eshopcheckout';
const coreBase = '/api/v1/core';

export const authString = 'Basic UFNIS0NNUzo4dHRONUF3MFh3bjYwTm0j';

export const fetchProductsFromCategory = async (categoryId = null) => {
	const products = await axios.get(`${eshopCatalogBase}/category/${categoryId}/products`);
	return products.data.data;
};

export const searchProducts = async (term = "", userId = null, isInternalOrder = false) => {
	if (typeof global.cancelToken != typeof undefined) {
		global.cancelToken.cancel("Operation canceled due to new request.");
	}
	global.cancelToken = axios.CancelToken.source();
	const params = {userId}

	if (isInternalOrder) {
		params.enableListing = true
	}

	let items = [];
	try {
		global.checkout.$emit('searchingStart')
		await axios.get(`${eshopCatalogBase}/product/search/${term}`, {
			cancelToken: global.cancelToken.token,
			params: params
		}).then(function (response) {
			global.checkout.$emit('searchingStop')
			items = response.data.data
		})
	} catch (error) {
	}

	return items;
};

export const searchAllProducts = async (userId = null, isInternalOrder = false) => {
	let items = [];
	const params = {userId}
	if (isInternalOrder) {
		params.enableListing = true
	}

	try {
		const result = await axios.get(`${eshopCatalogBase}/product/search-all`, {params: params})
		items = result.data
	} catch (error) {
	}

	return items
}

export const searchProductByCode = async (term = "", userId = null, isInternalOrder = false) => {
	if (typeof global.cancelToken != typeof undefined) {
		global.cancelToken.cancel("Operation canceled due to new request.");
	}
	global.cancelToken = axios.CancelToken.source();

	const params = {userId}
	if (isInternalOrder) {
		params.enableListing = true
	}

	let item = null;
	try {
		const response = await axios.get(`${eshopCatalogBase}/product/searchByCode/${term}`, {
			cancelToken: global.cancelToken.token,
			params: params,
			timeout: 10000
		});
		item = response.data
	} catch (error) {
		console.log(error)
	}

	return item;
};

export const getCategories = async () => {
	const categories = await axios.get(`${eshopCatalogBase}/category`);
	return categories.data.data;
};

export const getCountriesFromPaymentSpeditions = async () => {
	const countries = await axios.get(`${eshopOrdersBase}/payment-speditions/countries`, {headers: {'Authorization': authString}});
	return countries.data.data
};

export const getPaymentSpeditions = async () => {
	const countries = await axios.get(`${eshopOrdersBase}/payment-speditions`, {headers: {'Authorization': authString}});
	return countries.data.data
};

export const createOrder = async (checkoutProducts, globalSales, payment, spedition, customerId, totalPrice, transactionId, orderId, origin = 'eshopcheckout', country = null, isInternalOrder = false, orderType = null) => {
	const data = {
		checkoutProducts,
		globalSales,
		payment,
		spedition,
		customerId,
		totalPrice,
		transactionId,
		orderId,
		country,
		isInternalOrder,
		orderType
	};

	if (origin) {
		data.origin = origin
	}

	const result = await axios.post(`${eshopOrdersBase}/orders/create`, data, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true
		}
	}).catch(response => {
		return {
			error: true
		}
	});

	return result;
};

export const getAllCustomers = async () => {
	const result = await axios.get(`${eshopOrdersBase}/customers/all`, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true
		}
	}).catch(response => {
		return {
			error: true
		}
	});

	return result;
}

export const getCustomersInGroup = async () => {
	const result = await axios.get(`${eshopOrdersBase}/customers/in-group`, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true
		}
	}).catch(response => {
		return {
			error: true
		}
	});

	return result;
}

export const getGroupCustomers = async () => {
	const result = await axios.get(`${eshopOrdersBase}/customer-groups`, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true
		}
	}).catch(response => {
		return {
			error: true
		}
	});

	return result;
}

export const getPayments = async () => {
	const result = await axios.get(`${eshopOrdersBase}/payments`, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true
		}
	}).catch(response => {
		return {
			error: true
		}
	});

	return result;
}

export const getSpeditions = async () => {
	const result = await axios.get(`${eshopOrdersBase}/speditions`, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true
		}
	}).catch(response => {
		return {
			error: true
		}
	});

	return result;
}

export const getCountries = async () => {
	const result = await axios.get(`${coreBase}/countries`, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true
		}
	}).catch(response => {
		return {
			error: true
		}
	});

	return result;
}

export const getOrder = async (id) => {
	const result = await axios.get(`${eshopOrdersBase}/orders/${id}`, {
		headers: {
			'Authorization': authString,
		}
	}).then(response => {
		if (response.data.status === 'success') {
			return response.data.data
		}

		return {
			error: true,
			message: response.data.message
		}
	}).catch(error => {
		return {
			error: true,
			message: error.response.data.data.message
		};
	});

	return result
}

export const createCustomer = async (data) => {
	return await axios.post(`${eshopOrdersBase}/customers/create`, data, {
		headers: {
			'Authorization': authString,
		}
	})
}

export const checkDiscountCodeValidity = async (code, totalPrice) => {
	const result = await axios.post(`${eshopSalesBase}/sales/check-discount-code-validity`, {
		code,
		totalPrice
	})
	return result.data
}

export const getTerminals = async () => {
	const result = await axios.get(`${eshopCheckoutBase}/terminals/get-all`)
	return result.data.data
}

export const setActiveTerminal = async (terminalId) => {
	const result = await axios.post(`${eshopCheckoutBase}/terminals/set-active-terminal`, {terminalId})
	return result.data.data
}

export const removeTerminal = async (terminalId) => {
	const result = await axios.post(`${eshopCheckoutBase}/terminals/remove`, {terminalId})
	return result.data.data
}

export const saveTerminal = async (terminal) => {
	const result = await axios.post(`${eshopCheckoutBase}/terminals/save`, {...terminal})
	return result.data.data
}
