import Vue               from 'vue'
import App               from './Checkout'
import store             from './store'
import VueCurrencyFilter from 'vue-currency-filter'
import VueLazyload from 'vue-lazyload'

Vue.use(VueLazyload)

Vue.use(VueCurrencyFilter, {
	symbol: 'Kč',
	thousandsSeparator: ' ',
	fractionCount: 2,
	fractionSeparator: ',',
	symbolPosition: 'after',
	symbolSpacing: true
});

if (document.querySelector('#checkout')) {
	global.checkout = new Vue({
		store,
		render: h => h(App)
	}).$mount('#checkout');
}