import Vue from 'vue'
import Vuex                                                                    from 'vuex'
import {
	fetchProductsFromCategory,
	getCategories,
	searchProducts,
	searchProductByCode,
	createOrder,
	getTerminals,
	setActiveTerminal,
	removeTerminal,
	saveTerminal,
	searchAllProducts
} from "../api/api";
import {deepcopy, uuidv4, wait} from "../utils/utils";
import customerModel                                                           from "../models/customer";
import NexgoTerminalApi from "../api/nexgoTerminalApi";

Vue.use(Vuex);

export default new Vuex.Store({
	state: {
		allowDiscountCode: document.querySelector('.checkout-wrapper').dataset.allowDiscountCode === '1',
		allowNexgoTerminal: document.querySelector('.checkout-wrapper').dataset.allowNexgoTerminal === '1',
		allowPaymentByCard: document.querySelector('.checkout-wrapper').dataset.allowPaymentByCard === '1',
		allowEnterCodeFromScanner: document.querySelector('.checkout-wrapper').dataset.allowEnterCodeFromScanner === '1',
		allowPriceLevels: document.querySelector('.checkout-wrapper').dataset.allowPriceLevels === '1',
		allowDaySummary: document.querySelector('.checkout-wrapper').dataset.allowDaySummary === '1',
		allowEditOrder: document.querySelector('.checkout-wrapper').dataset.allowEditOrder === '1',
		allowMoneyBackCalc: document.querySelector('.checkout-wrapper').dataset.allowMoneyBackCalc === '1',
		allowEditQuantityInItemsList: document.querySelector('.checkout-wrapper').dataset.allowEditQuantityInItemsList === '1',
		allowDefineQuantityBeforeAddToCheckout: document.querySelector('.checkout-wrapper').dataset.allowDefineQuantityBeforeAddToCheckout === '1',
		allowRoundDiscountPrice: document.querySelector('.checkout-wrapper').dataset.allowRoundDiscountPrice === '1',
		allowConfirmOnCloseSendingOrderModal: document.querySelector('.checkout-wrapper').dataset.allowConfirmOnCloseSendingOrderModal === '1',
		openOrderReceiptImmediately: document.querySelector('.checkout-wrapper').dataset.openOrderReceiptImmediately === '1',
		isInternalOrderMode: document.querySelector('.checkout-wrapper').dataset.isInternalOrderMode === '1',
        allowIsClientOrderChbox: document.querySelector('.checkout-wrapper').dataset.allowIsClientOrderChbox === '1',
		visibleProducts: [],
		checkoutProducts: [],
		searchTerm: '',
		visibleCategories: [],
		shops: [],
		activeShop: '',
		categories: [],
		editedProductArrayId: -1,
		editedSaleArrayId: -1,
		totalPrice: 0,
		activeCategory: {},
		activeProduct: {},
		breadcrumb: [],
		editingSale: false,
		showDetailProduct: false,
		showDetailSale: false,
		showDetailDiscountCode: false,
		showDetailCustomer: false,
		showDetailTerminal: false,
		showAddCustomerModal: false,
		showSearchOrder: false,
		terminals: [],
		terminalsLoaded: false,
		customer: deepcopy(customerModel),
		customerName: null,
		selectedCustomer: null,
		editedOrder: null,
		selectedRow: null,
		detailProduct: {
			name: '',
			price: 0,
			count: 0,
			sale: {
				one: {
					id: null,
					name: '',
					staticSale: 0,
					percentSale: 0,
					note: '',
					saleCode: ''
				},
				all: {
					id: null,
					name: '',
					staticSale: 0,
					percentSale: 0,
					note: '',
					saleCode: ''
				}
			}
		},
		detailSale: {
			name: '',
			staticSale: 0,
			percentSale: 0,
			note: '',
			saleCode: ''
		},
		globalSales: [],
		staticSales: 0,
		percentSales: 0,
		rawPrice: 0,
		payment: null,
		spedition: null,
		country: null,
		orderType: null,
		statusWindow: {
			message: '',
			icon: 'info',
			active: false,
			orderReceipt: '',
			showCancel: false
		},
		defaultQuantity: {
			value: 1
		}
	},
	mutations: {
		SET_ORDER_TYPE(state, value) {
			state.orderType = value
		},
		SET_COUNTRY(state, value) {
			state.country = value
		},
		SET_PAYMENT(state, value) {
			state.payment = value
		},
		SET_SPEDITION(state, value) {
			state.spedition = value
		},
		SET_CUSTOMER_NAME(state, name) {
			state.customerName = name
		},
		SET_EDITED_ORDER(state, id) {
			state.editedOrder = id
		},
		SET_TERMINALS(state, items) {
			state.terminals = items
		},
		SET_VISIBLE_PRODUCTS(state, items) {
			let i = Array.isArray(items) ? items : []
			state.visibleProducts = i.length === 0 ? [] : i.map(productDecorate);
		},
		SET_SELECTED_CUSTOMER(state, value) {
			state.selectedCustomer = value
		},
		ADD_ITEM_TO_CHECKOUT(state, item) {
			const createBox = (el) => {
				const box = JSON.parse(JSON.stringify(productDecorate(el)))
				box.price = el.price
				box.name = el.boxName
				box.packageParentId = el.packageId
				box.packageId = null
				box.package = null
				delete box.isEditablePackage

				return box
			}

			const createSubitem = (parent, el) => {
				const item = JSON.parse(JSON.stringify(productDecorate(el)))
				item.packageParentId = parent.packageId
				item.packageId = null
				item.package = null
				delete item.isEditablePackage

				return item
			}

			let products = []

			item.step = 1
			products.push(JSON.parse(JSON.stringify(productDecorate(item))))
			if (item.package) {
				for (const packageContent of Object.values(item.package)) {
					packageContent.count = packageContent.quantity
					packageContent.step = packageContent.quantity
					products.push(JSON.parse(JSON.stringify(productDecorate(packageContent))))
				}
			}

			for (const el of products) {
				let existsInCheckout = false
				let count = Number.parseInt(el.count)
				el.count = el.count && el.count > 0 ? count : 1

				let i = -1
				for (const product of state.checkoutProducts) {
					i++
					const step = Number.parseInt(el.step)

					// produkt je v pokladne
					if (!state.selectedRow && product.id === el.id && product.packageParentId === el.packageParentId && !el.isEditablePackage) {
						product.count = Number.parseInt(product.count) + step
						existsInCheckout = true
						break
					}

					// produkt (editovatelny balicek) je jiz v pokladne, tak se vlozi jako krabicka
					if (state.selectedRow && el.isEditablePackage && product.packageId === state.selectedRow) {
						let boxExists = false
						for (const p of state.checkoutProducts) { // hledame krabicku v balicku, pokud tam je, tak se jen navysi pocet
							if (state.selectedRow === p.packageParentId && p.id === el.id) {
								p.count += 1
								boxExists = true
								break
							}
						}

						// krabicka v balicku neni, tudiz se prida
						if (!boxExists) {
							let checkoutProducts = state.checkoutProducts.slice(0, i + 1)
							checkoutProducts.push(createBox(product))
							checkoutProducts = checkoutProducts.concat(state.checkoutProducts.slice(i + 1))
							state.checkoutProducts = checkoutProducts
						}

						existsInCheckout = true
						break
					}

					// vkladame produkt do editovatelneho balicku
					if (state.selectedRow && !el.isEditablePackage && product.packageId === state.selectedRow) {
						let productExists = false
						for (const pr of state.checkoutProducts) { // hledame produkt v balicku, pokud tam je, tak se jen navysi pocet
							if (state.selectedRow === pr.packageParentId && pr.id === el.id) {
								pr.count += 1
								productExists = true
								break
							}
						}

						// produkt v balicku neni, tudiz se prida
						if (!productExists) {
							let chProducts = state.checkoutProducts.slice(0, i + 1)
							chProducts.push(createSubitem(product, el))
							chProducts = chProducts.concat(state.checkoutProducts.slice(i + 1))
							state.checkoutProducts = chProducts
						}

						existsInCheckout = true
						break
					}
				}

				if (!existsInCheckout) {
					if (el.isEditablePackage) {
						el.packageId += '_' + uuidv4()
						const box = createBox(el) // vytvorime krabicku

						el.price = 0
						state.checkoutProducts.push(el) // pridame wrapper s cenou 0

						// pridame krabicku pokud balicek neni nacten z objednavky (jiz krabicku ma)
						if (!el.orderItemId) {
							state.checkoutProducts.push(box)
						}
					} else {
						state.checkoutProducts.push(el)
					}
				}
			}
		},
		INCREASE_QUANTITY(state, item) {
			item.count++;
		},
		REMOVE_ITEM_FROM_CHECKOUT(state, item) {
			item.count--;
		},
		REMOVE_ALL_PIECES_OF_ITEM_FROM_CHECKOUT(state, arrayId) {
			state.checkoutProducts.splice(arrayId, 1);
			if (state.selectedRow && state.checkoutProducts.filter(el => el.packageId && state.selectedRow && el.packageId === state.selectedRow).length === 0) {
				state.selectedRow = null
			}
		},
		SET_VISIBLE_CATEGORIES(state, categories) {
			state.visibleCategories = categories;
		},
		SET_CATEGORIES(state, categories) {
			state.categories = categories;
		},
		RESET(state) {
			state.checkoutProducts = [];
			state.visibleProducts = [];
			state.globalSales = [];
			state.selectedCustomer = null;
			state.editedOrder = null;
		},
		RECALCULATE(state) {
			startLoader();
			let sum = 0;
			let sumWithoutSales = 0;
			let staticSales = 0;
			let percentSales = 0;
			state.checkoutProducts.forEach(product => {

				// Standartni pocet kusu * cena
				sum += (parseFloat(product.price) * product.count);
				sumWithoutSales = sum;

				// Pevna sleva na vsechny
				if (product.sale.all.staticSale > 0) {
					sum -= product.sale.all.staticSale;
					staticSales += parseFloat(product.sale.all.staticSale);
				}

				// Procentuelni sleva na vsechny
				if (product.sale.all.percentSale > 0) {
					const sale = ((parseFloat(product.price) * product.count) / 100) * product.sale.all.percentSale;
					sum -= sale;
					staticSales += sale;
				}

				// Pevna sleva na kus
				if (product.sale.one.staticSale) {
					const sale = product.sale.one.staticSale * product.count;
					sum -= sale;
					staticSales += sale;
				}

				// Procentuelni sleva na kus
				if (product.sale.one.percentSale) {
					const sale = ((product.price / 100) * product.sale.one.percentSale) * product.count;
					sum -= sale;
					staticSales += sale;
				}

			});
			state.rawPrice = sum; // $sumWithoutSales
			state.globalSales.forEach(sale => {
				staticSales += parseFloat(sale.staticSale);
				percentSales += parseFloat(sale.percentSale);
				sum -= parseFloat(sale.staticSale);
			});

			state.staticSales = staticSales;
			state.percentSales = percentSales;

			let percentSaleInValue = ((sum / 100) * percentSales)
			if (state.allowRoundDiscountPrice) {
				percentSaleInValue = Math.ceil(percentSaleInValue)
			}

			let itemsPrice = sum - percentSaleInValue
			let totalPrice = itemsPrice

			if (state.payment) {
				totalPrice += state.payment.price
			}

			if (state.spedition) {
				totalPrice += state.spedition.freeFrom && state.spedition.freeFrom <= itemsPrice ? 0 : state.spedition.price
			}

			state.totalPrice = totalPrice;
			stopLoader();
		},

		// PRODUCT
		SET_PRODUCT_DETAIL(state, product) {
			state.detailProduct = product
		},
		EDIT_PRODUCT(state, product) {
			Vue.set(state.checkoutProducts, state.editedProductArrayId, product);
		},

		// SALES
		ADD_GLOBAL_SALE(state, sale) {
			state.globalSales.push(sale);
		},
		SET_DETAIL_SALE(state, sale) {
			state.detailSale = sale;
		},
		REMOVE_GLOBAL_SALE(state, sale) {
			let index = state.globalSales.indexOf(sale);
			if (index !== -1) state.globalSales.splice(index, 1);
		},

		EDIT_GLOBAL_SALE(state, sale) {
			Vue.set(state.globalSales, state.editedSaleArrayId, sale);
		},

		// Breadcrumb
		ADD_TO_BREADCRUMB(state, breadcrumb) {
			if (state.breadcrumb.filter(item => item.id === breadcrumb.id))
				state.breadcrumb.push(breadcrumb);
		},
		SET_BREADCRUMB(state, breadcrumb) {
			state.breadcrumb = [breadcrumb];
		},

		// Customer
		SET_CUSTOMER(state, customer) {
			state.customer = customer;
		},
		SET_CUSTOMER_CREATED(state) {
			state.customer.customerCreated = true
		},
		SET_CUSTOMER_FROM_API(state, customer) {
			if (customer.addressInvoice)
				state.customer.addressInvoice = deepcopy(customer.addressInvoice);
			if (customer.addressDelivery)
				state.customer.addressDelivery = deepcopy(customer.addressDelivery);
		},
		// Modals
		SET_PRODUCT_DETAIL_MODAL(state, active) {
			state.showDetailProduct = active;
		},
		SET_DISCOUNT_CODE_MODAL(state, active) {
			state.showDetailDiscountCode = active;
		},
		SET_SALE_DETAIL_MODAL(state, active) {
			state.showDetailSale = active;
			if (!active) state.editingSale = false;
		},
		SET_CUSTOMER_DETAIL_MODAL(state, active) {
			state.showDetailCustomer = active;
		},
		SET_TERMINAL_DETAIL_MODAL(state, active) {
			state.showDetailTerminal = active;
		},
		SET_ADD_CUSTOMER_MODAL(state, active) {
			state.showAddCustomerModal = active;
		},
		// Status
		SET_STATUS_WINDOW(state, {message, icon, active, orderReceipt, showCancel}) {
			if (message) state.statusWindow.message = message;
			if (icon) state.statusWindow.icon = icon;
			if (active !== undefined) state.statusWindow.active = active;
			if (orderReceipt !== undefined) state.statusWindow.orderReceipt = orderReceipt;
			if (showCancel !== undefined) state.statusWindow.showCancel = showCancel;
		},
		// Shop
		SET_ACTIVE_SHOP(state, shop) {
			state.activeShop = shop;
		},
		SET_SHOPS(state, shops) {
			state.shops = shops;
		},
		RESET_SELECTED_ROW(state, val) {
			state.selectedRow = null
		},
		SET_SELECTED_ROW(state, val) {
			state.selectedRow = val
		}
	},
	actions: {
		setVisibleSearchOrder({state, commit}, value) {
			state.showSearchOrder = value

			if (value === true) {
				commit('RESET')
				commit('RECALCULATE')
			} else {
				state.customerName = null
			}
		},
		resetSelectedRow({commit}) {
			commit('RESET_SELECTED_ROW', null);
		},
		increaseQuantity({commit}, item) {
			commit('INCREASE_QUANTITY', item);
			commit('RECALCULATE');
		},
		removeItemFromCheckout({commit}, item) {
			commit('REMOVE_ITEM_FROM_CHECKOUT', item);
			commit('RECALCULATE');
		},
		removeAllPiecesOfItemFromCheckout({commit}, arrayID) {
			commit('REMOVE_ALL_PIECES_OF_ITEM_FROM_CHECKOUT', arrayID);
			commit('RECALCULATE');
		},
		async getProductsFromCategory({commit, state}, categoryId) {
			startLoader();
			if (categoryId)
				commit('SET_VISIBLE_PRODUCTS', await fetchProductsFromCategory(categoryId))
			stopLoader();
		},
		async addItemToCheckout({commit}, item) {
			commit('ADD_ITEM_TO_CHECKOUT', item);
			commit('RECALCULATE');
		},

		async checkout({state, dispatch, commit, getters}, {payment, spedition, transactionId}) {
			commit('SET_STATUS_WINDOW', {
					active: true,
					message: `Zpracovávám objednávku ${state.customer.customerCreated ? `<br>pro ${getters.customerName} ${getters.customerSurname}` : ``}`,
					icon: 'info',
					orderReceipt: null,
					showCancel: false
				}
			);
			const {checkoutProducts, globalSales, selectedCustomer, totalPrice, editedOrder} = state;
			const result = await createOrder(
				checkoutProducts,
				globalSales,
				payment,
				spedition,
				selectedCustomer,
				totalPrice,
				transactionId,
				editedOrder,
				state.isInternalOrderMode ? null : 'eshopcheckout',
				state.country,
				state.isInternalOrderMode,
				state.orderType
			);
			if (!result.error) {
				commit('SET_STATUS_WINDOW', {active: true, message: 'Objednávka dokončena', icon: 'completed', orderReceipt: result.orderReceipt, showCancel: false});
			} else {
				commit('SET_STATUS_WINDOW', {
					active: true,
					message: 'Vyskytla se chyba<br> Objednávka nebyla uložena',
					icon: 'error',
					orderReceipt: null,
					showCancel: false
				});
			}
		},
		async checkoutInternalOrder({dispatch, state}) {
			dispatch('checkout', {payment: state.payment?.id, spedition: state.spedition?.id, transactionId: null});
		},
		async checkoutCash({dispatch}) {
			dispatch('checkout', {payment: 'storeCash', spedition: 'pickup', transactionId: null});
		},
		async checkoutCreditCard({dispatch}) {
			dispatch('checkout', {payment: 'storeCard', spedition: 'pickup', transactionId: null});
		},
		async checkoutCreditCardByNexgoTerminal({commit, dispatch, getters, state}) {
			global.stopCreatingPayment = false
			const activeTerminal = getters.getActiveTerminal
			if (!activeTerminal) {
				commit('SET_STATUS_WINDOW', {
						active: true,
						message: 'Vyberte prosím v platebních terminálech terminál, na který má být odeslána platba',
						icon: 'error',
						orderReceipt: null,
						showCancel: false
					}
				)

				return
			}

			const nexgoTerminalApi = new NexgoTerminalApi(activeTerminal.ip, activeTerminal.port, activeTerminal.secureString)
			const transactionId = uuidv4()

			commit('SET_STATUS_WINDOW', {
					active: true,
					message: 'Vyčkávání na platbu',
					icon: 'card',
					orderReceipt: null,
					showCancel: true
				}
			)

			// zkusime nejvíce 3krat s prodlevou 350 ms zalozit platbu
			const rep = 3
			for (let i = 0; i < rep; i++) {
				if (global.stopCreatingPayment) {
					return
				}

				let response = null
				try {
					response = await nexgoTerminalApi.createPaymentNexgoTerminal(transactionId, state.totalPrice)
				} catch (e) {}

				if (response?.status === 202) { // server busy -> byla odeslana nova platba, ale prechodzi jeste neni dokoncena
					commit('SET_STATUS_WINDOW', {
							active: true,
							message: 'Předchozí platba není ještě dokončena',
							icon: 'error',
							orderReceipt: null,
							showCancel: false
						}
					)

					return
				} else if (response?.data?.status.toLowerCase() !== 'ok') {
					if (i === (rep - 1)) {
						commit('SET_STATUS_WINDOW', {
								active: true,
								message: 'Nepodařilo se odeslat platbu na terminál',
								icon: 'error',
								orderReceipt: null,
								showCancel: false
							}
						)

						return
					}

					await wait(350)
				} else {
					break
				}
			}

			let interval = setInterval(async () => {
				const result = await nexgoTerminalApi.checkPaymentStatusNexgoTerminal(transactionId)
				if (result.data.status === 'Finished') {
					clearInterval(interval)
					const result = await nexgoTerminalApi.getPaymentResult(transactionId)

					if (result.data.responseCode.toLowerCase() !== 'ok') {
						commit('SET_STATUS_WINDOW', {
							active: true,
							message: 'Transakce nebyla dokončena',
							icon: 'error',
							orderReceipt: null,
							showCancel: false
						})
					} else {
						const confirm = await nexgoTerminalApi.confirmPayment(transactionId)

						if (confirm.data.isConfirmed) {
							dispatch('checkout', {payment: 'storeCard', spedition: 'pickup', transactionId})
						}
					}
				}
			}, 1000)
		},
		async getTerminals({commit, state}) {
			startLoader()
			const terminals = await getTerminals()
			commit('SET_TERMINALS', terminals)
			state.terminalsLoaded = true
			stopLoader()
		},
		async setActiveTerminal({commit, state}, terminalId) {
			startLoader()
			const result = await setActiveTerminal(terminalId)

			if (result.status === 'error') {
				stopLoader()
				return false
			}

			state.terminals.forEach((el, i) => {
				state.terminals[i].isActive = terminalId === el.id ? 1 : 0
			})

			stopLoader()

			return true
		},
		async removeTerminal({commit, state}, terminalId) {
			startLoader()
			const result = await removeTerminal(terminalId)

			if (result.status === 'error') {
				stopLoader()
				return false
			}

			state.terminals.forEach((el, i) => {
				if (el.id === terminalId) {
					state.terminals.splice(i, 1)
				}
			})

			stopLoader()
			return true
		},
		async saveTerminal({commit, state}, terminal) {
			startLoader()
			const result = await saveTerminal(terminal)

			if (result.status === 'error') {
				stopLoader()
				return false
			}

			const editedTerminal = result.data
			let founded = false
			state.terminals.forEach((el, i) => {
				if (el.id === editedTerminal.id) {
					state.terminals[i].id = editedTerminal.id
					state.terminals[i].ip = editedTerminal.ip
					state.terminals[i].port = editedTerminal.port
					state.terminals[i].secureString = editedTerminal.secureString
					state.terminals[i].isActive = editedTerminal.isActive
					state.terminals[i].terminalId = editedTerminal.terminalId
					founded = true
				}
			})

			if (!founded) {
				state.terminals.push(editedTerminal)
			}

			stopLoader()
			return true
		},
		reset({commit, dispatch}) {
			commit('RESET');
			commit('SET_SPEDITION', null);
			commit('SET_PAYMENT', null);
			commit('SET_ORDER_TYPE', null);
			commit('SET_CUSTOMER_NAME', null);
			commit('SET_CUSTOMER', deepcopy(customerModel));
			commit('SET_PRODUCT_DETAIL_MODAL', false);
			commit('SET_SALE_DETAIL_MODAL', false);
			commit('SET_CUSTOMER_DETAIL_MODAL', false);
			commit('SET_STATUS_WINDOW', {active: false});
			commit('RECALCULATE');
			// dispatch('getRootCategories');
		},
		async searchAll({commit,state}) {
			const products = await searchAllProducts(state.selectedCustomer, state.isInternalOrderMode);
			commit('SET_VISIBLE_PRODUCTS', Object.values(products));
			commit('SET_VISIBLE_CATEGORIES', []);
			commit('SET_BREADCRUMB', {index: 0, id: 'search', name: 'Výsledek hledání'});
		},
		async search({commit,state}, term = "") {
			if (term.length > 0) {
				const products = await searchProducts(term, state.selectedCustomer, state.isInternalOrderMode);
				commit('SET_VISIBLE_PRODUCTS', Object.values(products));
			} else {
				commit('SET_VISIBLE_PRODUCTS', []);
			}
			commit('SET_VISIBLE_CATEGORIES', []);
			commit('SET_BREADCRUMB', {index: 0, id: 'search', name: 'Výsledek hledání'});
		},
		async searchByCode({commit,state}, term = "") {
			const product = await searchProductByCode(term, state.selectedCustomer, state.isInternalOrderMode)

			if (!product) {
				return null
			}

			return productDecorate(product)
		},
		// Method for checkout initialization
		async getRootCategories({commit}) {
			startLoader();
			const categories = await getCategories();
			const shops = Object.keys(categories);
			commit('SET_SHOPS', shops);
			commit('SET_ACTIVE_SHOP', shops[0]);
			commit('SET_VISIBLE_CATEGORIES', categories[shops[0]]);
			commit('SET_CATEGORIES', categories);
			commit('SET_BREADCRUMB', {index: 0, id: null, name: shops[0]});
			stopLoader();
		},
		switchShop({state, commit}, shop) {
			startLoader();
			commit('SET_ACTIVE_SHOP', shop);
			commit('SET_VISIBLE_CATEGORIES', state.categories[shop]);
			commit('SET_BREADCRUMB', {index: 0, id: null, name: shop});
			commit('SET_VISIBLE_PRODUCTS', []);
			stopLoader();
		},
		getChildrenOfCategory({commit}, {category, index}) {
			if (category.child) {
				commit('SET_VISIBLE_CATEGORIES', category.child);
			} else {
				commit('SET_VISIBLE_CATEGORIES', []);
			}
			commit('ADD_TO_BREADCRUMB', {index, id: category.id, name: category.name})
		},
		// Products
		setProductToEdit({commit, state}, {arrayId, product}) {
			state.editedProductArrayId = arrayId;
			commit('SET_PRODUCT_DETAIL', deepcopy(product));
			commit('SET_PRODUCT_DETAIL_MODAL', true)
		},

		editProduct({commit}, product) {
			commit('EDIT_PRODUCT', deepcopy(product));
			commit('SET_PRODUCT_DETAIL_MODAL', false);
			commit('RECALCULATE');
		},

		// Sales
		setGlobalSaleToEdit({commit, state}, {sale, arrayId}) {
			state.editingSale = true;
			state.editedSaleArrayId = arrayId;
			commit('SET_DETAIL_SALE', deepcopy(sale));
			commit('SET_SALE_DETAIL_MODAL', true)
		},

		addGlobalSale({commit}, sale) {
			commit('ADD_GLOBAL_SALE', deepcopy(sale));
			commit('SET_SALE_DETAIL_MODAL', false);
			commit('RECALCULATE');
		},

		editGlobalSale({commit}, sale) {
			commit('EDIT_GLOBAL_SALE', deepcopy(sale));
			commit('SET_SALE_DETAIL_MODAL', false);
			commit('RECALCULATE');
		},
		removeGlobalSale({commit}, sale) {
			commit('REMOVE_GLOBAL_SALE', sale);
			commit('RECALCULATE');
		},

		// Breadcrumb
		refreshByBreadcrumbId({commit, state, dispatch}, breadcrumbId) {
			let categories = state.categories;
			if (breadcrumbId > 0) {
				categories = categories[state.breadcrumb[breadcrumbId].index];
				for (let i = 0; i < breadcrumbId; i++)
					categories = categories.child;
				dispatch('getProductsFromCategory', state.breadcrumb[breadcrumbId].id);
				commit('SET_VISIBLE_CATEGORIES', categories);
			} else {
				commit('SET_BREADCRUMB', {index: 0, id: null, name: state.activeShop});
				commit('SET_VISIBLE_PRODUCTS', []);
				commit('SET_VISIBLE_CATEGORIES', categories[state.activeShop]);
			}
			if(breadcrumbId > 0) {
				state.breadcrumb.splice(breadcrumbId + 1);
			}
		},

		// Customer
		saveCustomer({commit}, customer) {
			commit('SET_CUSTOMER', deepcopy(customer));
			commit('SET_CUSTOMER_DETAIL_MODAL', false);
			commit('SET_CUSTOMER_CREATED', true);
		},
		deleteCustomer({commit}) {
			commit('SET_CUSTOMER', deepcopy(customerModel))
		},
		setCustomerFromApi({commit}, customer) {
			commit('SET_CUSTOMER_FROM_API', customer);
		},
		// Modals
		setProductModal({commit}, state) {
			commit('SET_PRODUCT_DETAIL_MODAL', state)
		},
		setSaleModal({commit}, state) {
			commit('SET_SALE_DETAIL_MODAL', state);
		},
		setDiscountCodeModal({commit}, state) {
			commit('SET_DISCOUNT_CODE_MODAL', state);
		},
		setCustomerModal({commit}, state) {
			commit('SET_CUSTOMER_DETAIL_MODAL', state);
		},
		setTerminalModal({commit}, state) {
			commit('SET_TERMINAL_DETAIL_MODAL', state);
		},
		setAddCustomerModal({commit}, state) {
			commit('SET_ADD_CUSTOMER_MODAL', state);
		},
		setStatusWindow({commit}, state) {
			commit('SET_STATUS_WINDOW', {active: state})
		}
	},
	getters: {
		customerName: (state) => {
			return state.customer.addressInvoice.firstName ? state.customer.addressInvoice.firstName : state.customer.addressDelivery.firstName;

		},
		customerSurname: (state) => {
			return state.customer.addressInvoice.lastName ? state.customer.addressInvoice.lastName : state.customer.addressDelivery.lastName;
		},
		getActiveTerminal: (state) => {
			for (const terminal of state.terminals) {
				if (terminal.isActive) {
					return terminal
				}
			}

			return null
		},
		getOrderType: (state) => {
			return state.orderType
		}
	}
})

export const startLoader = () => {
	const body = document.querySelector('body')

	let el = body.querySelector('#loader-wrapper')
	if (!el) {
		el = document.createElement('div')
		el.setAttribute('id', 'loader-wrapper')
		body.appendChild(el)
	}

	el.insertAdjacentHTML('beforeend', `<div id="loading-overlay" class="loading-control" data-count="1">
		<div class="spinner">
		<div class="rect1"></div>
		<div class="rect2"></div>
		<div class="rect3"></div>
		<div class="rect4"></div>
		</div>
		</div>`)
};
export const stopLoader = () => {
	document.querySelector('#loading-overlay').remove();
};

export const productDecorate = (product) => {
	product.packageId = product.packageId ?? null
	product.packageParentId = product.packageParentId ?? null
	product.orderItemParentId = product.orderItemParentId ?? null // TODO
	product.note = product.note ?? null
	product['price'] = parseFloat(product.price)
	product['count'] = product['count'] ? product['count'] : 0;
	product['quantity'] = product['quantity'] ? product['quantity'] : 0;
	product['sale'] = product['sale'] ? product['sale'] : {
		all: {
			id: null,
			name: '',
			staticSale: 0,
			percentSale: 0,
			note: '',
			saleCode: ''
		},
		one: {
			id: null,
			name: '',
			staticSale: 0,
			percentSale: 0,
			note: '',
			saleCode: ''
		}
	}
	return product
}