export const deepcopy = (data) => {
	return JSON.parse(JSON.stringify(data))
};
export const fetchFromObject = (obj, prop) => {

	if (typeof obj === 'undefined') {
		return false;
	}

	const _index = prop.indexOf('.');
	if (_index > -1) {
		return fetchFromObject(obj[prop.substring(0, _index)], prop.substr(_index + 1));
	}

	return obj[prop];
};

export const uuidv4 = () => {
	return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
		var r = Math.random() * 16 | 0,
			v = c === 'x' ? r : r & 0x3 | 0x8;
		return v.toString(16)
	})
}

export const wait = async (time) => new Promise(resolve => {setTimeout(resolve, time)})