<?php declare(strict_types = 1);

namespace EshopCheckout\AdminModule\Components\DashboardWidgets;

use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopCheckout\AdminModule\Model\Statistics\Statistics;
use EshopOrders\AdminModule\Components\DashboardWidgets\BaseEshopOrdersWidget;

class Todays extends BaseEshopOrdersWidget implements IWidget
{
	protected string $gridSize = 'col-md-4 col-xxl-3';
	protected string $key      = 'eshopCheckoutTodays';

	/** @var Statistics|null @inject */
	public ?Statistics $statistics = null;

	public function render(): void
	{
		if (!$this->loggedUser->isAllowed('EshopCheckout:Admin', 'access')) {
			return;
		}

		$this->template->key    = $this->key;
		$this->template->icon   = 'fas fa-cash-register';
		$this->template->title  = $this->t('eshopCheckout.dashboardWidget.todays.title');
		$this->template->icon2  = 'fas fa-store';
		$this->template->title2 = $this->t('eshopCheckout.dashboardWidget.todays.titlePickup');
		$this->template->data   = $this->statistics ? $this->statistics->getTodayStore() : [];

		$this->template->baseTemplate = $this->baseTemplate;
		$this->template->render($this->getTemplateFile());
	}

}
