<?php declare(strict_types = 1);

namespace EshopCheckout\AdminModule\Model\Statistics;

use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\AdminModule\Model\Statistics\Statistics as EshopOrdersStatistics;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;

class Statistics
{
	protected EntityManagerDecorator $em;
	protected EshopOrdersStatistics  $eshopOrdersStats;

	public function __construct(
		EntityManagerDecorator $em,
		EshopOrdersStatistics  $eshopOrdersStats
	)
	{
		$this->em               = $em;
		$this->eshopOrdersStats = $eshopOrdersStats;
	}

	public function getTodayStore(): array
	{
		$result = [
			'checkout' => [
				'storeCard' => [
					'price' => 0,
					'count' => 0,
				],
				'storeCash' => [
					'price' => 0,
					'count' => 0,
				],
			],
			'pickup'   => [
				'card'  => [
					'price' => 0,
					'count' => 0,
				],
				'store' => [
					'price' => 0,
					'count' => 0,
				],
			],
		];

		$canceled = $this->eshopOrdersStats->getTodayStatusIds(OrderStatus::STATUS_CANCELED);

		$todayDone = $this->eshopOrdersStats->getTodayStatusIds(OrderStatus::STATUS_FINISHED);
		foreach ($this->eshopOrdersStats->getBaseQueryBuilder()
			         ->andWhere('o.id IN (:ids)')
			         ->setParameters([
				         'ids' => array_diff(array_keys($todayDone), array_keys($canceled)),
			         ])
			         ->groupBy('o.id')
			         ->getQuery()->getResult() as $order) {
			/** @var Order $order */
			if ($order->getParam('origin') === 'eshopcheckout') {
				$result['checkout'][$order->getPaymentIdent()]['price'] += $order->getPrice();
				$result['checkout'][$order->getPaymentIdent()]['count']++;
			} else {
				if ($order->getSpeditionIdent() !== 'pickup' || ($order->site && $order->site->getIdent() === 'don')) {
					continue;
				}

				$paymentIdent = $order->getPaymentIdent();
				switch ($paymentIdent) {
					case 'storeCard':
						$paymentIdent = 'card';
						break;
					case 'storeCash':
						$paymentIdent = 'store';
						break;
				}

				$result['pickup'][$paymentIdent]['price'] += $order->getPrice();
				$result['pickup'][$paymentIdent]['count']++;
			}
		}

		return $result;
	}
}
