<?php declare(strict_types = 1);

namespace EshopCheckout\AdminModule\Presenters;

use Nette\Application\BadRequestException;

class InternalOrdersPresenter extends BasePresenter
{
	public function checkRequirements($element): void
	{
		try {
			parent::checkRequirements($element);
		} catch (BadRequestException $e) {
			if (!$this->getUser()->isAllowed($this->getFullModuleName() . ':InternalOrders', 'access')) {
				$this->error();
			}
		}
	}

	public function actionDefault(): void
	{
		$this->setTitle($this->translator->translate('eshopCheckout.title.internalOrder'));
		$this->setHeader($this->translator->translate('eshopCheckout.title.internalOrder'));

		$this->template->isInternalOrderMode = true;
		$this->template->setFile(__DIR__ . '/../Templates/Default/default.latte');
	}
}