<?php declare(strict_types = 1);

namespace EshopCheckout\AdminModule\Presenters;

use Core\Model\Event\Event;
use Core\Model\Templating\Template;
use EshopCheckout\AdminModule\Model\Statistics\Statistics;
use Nette\Application\AbortException;
use Nette\Application\BadRequestException;
use Nette\Application\Responses\TextResponse;

class OrderReceiptsPresenter extends BasePresenter
{
	/** @var Statistics @inject */
	public Statistics $statistics;

	/**
	 * @param string|int $orderId
	 *
	 * @throws BadRequestException
	 * @throws AbortException
	 */
	public function actionReceipt($orderId): void
	{
		$order = $this->orders->get((int) $orderId);

		if (!$order) {
			$this->error();
		}

		$receipt = $this->orderReceiptBuilderFactory->create($order);
		$this->sendResponse(new TextResponse($receipt->build()->renderToString()));
	}

	public function actionDaySummary(): void
	{
		/** @var Template $template */
		$template = $this->createTemplate();
		$template->setFile(__DIR__ . '/../../Templates/Receipt/daySummary.latte');

		$data = $this->statistics->getTodayStore();
		$this->eventDispatcher->dispatch(new Event(['data' => &$data, 'template' => &$template]), 'eshopCheckout.daySummary');
		$template->data = $data;

		$this->sendResponse(new TextResponse($template->renderToString()));
	}

}
