<?php declare(strict_types = 1);

namespace EshopCheckout\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_checkout__terminal")
 * @ORM\Entity
 */
class Terminal
{
	use TId;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $ip;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $port;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $secureString;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $terminalId;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $isActive = 0;

	public function __construct(string $ip, string $port, string $secureString, string $terminalId)
	{
		$this->ip = $ip;
		$this->port = $port;
		$this->secureString = $secureString;
		$this->terminalId = $terminalId;
	}

}