<?php declare(strict_types = 1);

namespace EshopCheckout\Model\Entities;

use EshopOrders\Model\Entities\Order;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_checkout__transaction")
 * @ORM\Entity
 */
class Transaction
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Order $order;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	protected string $trasactionId;

	public function __construct(Order $order, string $trasactionId)
	{
		$this->order = $order;
		$this->trasactionId = $trasactionId;
	}

}