<?php declare(strict_types = 1);

namespace EshopCheckout\Model\Subscribers;

use EshopOrders\Model\Event\OrderPayloadReturnEvent;
use Nette\Application\LinkGenerator;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderFormPayloadReturnSubscriber implements EventSubscriberInterface
{
	protected LinkGenerator $linkGenerator;

	public function __construct(
		LinkGenerator $linkGenerator
	)
	{
		$this->linkGenerator = $linkGenerator;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.api.orderPayloadReturnEvent' => ['orderPayloadModify', 100],
		];
	}

	public function orderPayloadModify(OrderPayloadReturnEvent $event): void
	{
		$link = null;
		if (!$event->order->getInvoice()) {
			if ($event->order->isCorrectiveTaxDocument) {
				$link = $this->linkGenerator->link('EshopOrders:Admin:Orders:Invoice', ['orderId' => $event->order->getId()]);
			} else {
				$link = $this->linkGenerator->link('EshopCheckout:Admin:OrderReceipts:Receipt', ['orderId' => $event->order->getId()]);
			}
		}
		$event->data['orderReceipt'] = $link;
	}

}
