<?php declare(strict_types = 1);

namespace EshopCheckout\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\UI\DataGrid\BaseDataGrid;
use EshopOrders\AdminModule\Components\Order\OrdersGrid;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Application\LinkGenerator;
use Nette\Utils\Html;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrdersSubscriber implements EventSubscriberInterface
{
	protected LinkGenerator $linkGenerator;

	public function __construct(
		LinkGenerator $linkGenerator
	)
	{
		$this->linkGenerator = $linkGenerator;
	}

	/**
	 * @return string[]
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			OrdersGrid::class . '::onAttach' => 'ordersGridAttached',
		];
	}

	public function ordersGridAttached(ControlEvent $event): void
	{
		/** @var BaseDataGrid $grid */
		$grid = $event->control['grid'];

		$grid->addAction('receipt', '')->setRenderer(function(Order $order) {
			$isEshopCheckoutOrder = in_array($order->getPaymentIdent(), ['storeCash', 'storeCard']);
			$allowInvoiceForEshopCheckout = EshopOrdersConfig::load('invoice.allowForEshopCheckout', false);

			if (!$isEshopCheckoutOrder || $order->isCorrectiveTaxDocument || ($order->getInvoice() && !$allowInvoiceForEshopCheckout)) {
				return '';
			}

			return Html::el('a', ['href'  => $this->linkGenerator->link('EshopCheckout:Admin:OrderReceipts:Receipt', ['orderId' => $order->getId()]),
			                      'class' => 'btn btn-success btn-xs', 'target' => '_blank'])
				->addHtml(Html::el('i', ['class' => 'fas fa-file-invoice-dollar']));
		});
	}

}
