<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Presenters;

use EshopGifts\AdminModule\Components\CategoryGiftForm;
use EshopGifts\AdminModule\Components\CategoryGiftsGrid;
use EshopGifts\AdminModule\Components\ICategoryGiftFormFactory;
use EshopGifts\AdminModule\Components\ICategoryGiftsGridFactory;

class DefaultPresenter extends BasePresenter
{
	protected const ICON = 'fas fa-gift';

	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopGifts.title.gifts', self::ICON);
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleAddCategoryGift(): void
	{
		$this->template->modalTitle       = $this->t('eshopGifts.title.newCategoryGift');
		$this->template->modal            = 'categoryGift';
		$this->template->modalDialogClass = 'modal-xl';
		$this->redrawControl('modal');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopGifts.menu.newCategoryGift',
				'link'  => $this->link('addCategoryGift!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentCategoryGiftsGrid(ICategoryGiftsGridFactory $factory): CategoryGiftsGrid
	{
		return $factory->create();
	}

	protected function createComponentCategoryGiftForm(ICategoryGiftFormFactory $factory): CategoryGiftForm
	{
		$control = $factory->create();

		$control->onAnchor[] = function() use ($control) {
			$control['form']->onSuccessSave[] = function() {
				$this->redrawControl('flashes');
				$this['categoryGiftsGrid']['grid']->reload();
			};

			$control['form']->onSuccessSaveAndClose[] = function() {
				$this->payload->hideModal = true;
				$this->redrawControl('flashes');
				$this['categoryGiftsGrid']['grid']->reload();
			};

			$control['form']['saveControl']->closeModalOnCancel();
		};

		return $control;
	}
}
