<?php declare(strict_types = 1);

namespace EshopGifts\FrontModule\Model\Dao;

use EshopCatalog\FrontModule\Model\Dao\Product;

class Gift
{
	/** @var Product */
	protected $product;

	/** @var string */
	protected $name;

	/** @var string */
	protected $description;

	public function __construct(Product $product, ?string $name = null, ?string $description = null)
	{
		$this->product     = $product;
		$this->name        = $name ?: $product->getName();
		$this->description = $description ?: $product->shortDescription;
	}

	public function getProduct(): Product { return $this->product; }

	public function getName(): string { return $this->name; }

	public function getDescription(): string { return $this->description; }
}
