<?php declare(strict_types = 1);

namespace EshopGifts\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use EshopCatalog\Model\Entities\Category;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_gifts__category_gift")
 * @ORM\Entity
 */
class CategoryGift
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var Product
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="gift_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected $gift;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255, nullable=true)
	 */
	public $name;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="string", nullable=true)
	 */
	public $description;

	/**
	 * @var Category[]
	 * @ORM\ManyToMany(targetEntity="EshopCatalog\Model\Entities\Category")
	 * @ORM\JoinTable(name="eshop_gifts__category_gifts",
	 *     joinColumns={@ORM\JoinColumn(name="gift_id", referencedColumnName="id")},
	 *     inverseJoinColumns={@ORM\JoinColumn(name="category_id", referencedColumnName="id")})
	 */
	protected $categories;

	/**
	 * @var double
	 * @ORM\Column(name="price_from", type="decimal", precision=10, scale=2, nullable=true)
	 */
	public $priceFrom;

	/**
	 * @var double
	 * @ORM\Column(name="price_to", type="decimal", precision=10, scale=2, nullable=true)
	 */
	public $priceTo;

	/**
	 * @var DateTime
	 * @ORM\Column(name="date_from", type="datetime", nullable=true)
	 */
	public $dateFrom;

	/**
	 * @var DateTime
	 * @ORM\Column(name="date_to", type="datetime", nullable=true)
	 */
	public $dateTo;

	/**
	 * @var int
	 * @ORM\Column(name="is_active", type="smallint", length=1, options={"default": 1})
	 */
	protected $isActive;

	public function __construct(Product $gift)
	{
		$this->setProduct($gift);
		$this->categories = new ArrayCollection();
		$this->isActive   = 1;
	}

	public function getProduct(): Product { return $this->gift; }

	public function setProduct(Product $gift): self
	{
		$this->gift = $gift;

		return $this;
	}

	public function isActive(): int { return (int) $this->isActive; }

	public function setActive($active): self
	{
		$this->isActive = (int) $active;

		return $this;
	}

	public function getCategories() { return $this->categories; }

	public function setCategories(array $ids): self
	{
		$this->categories = new ArrayCollection($ids);

		return $this;
	}
}
