import autoComplete from "core/../node_modules/@tarekraafat/autocomplete.js/src/models/autoComplete"

let categoryGiftFormDataLoaded = null;

document.addEventListener('DOMContentLoaded', () => {
	initCategoryGiftForm();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initCategoryGiftForm();
	});

	global.naja.addEventListener('complete', e => {
		initCategoryGiftForm();
	});
});

const initCategoryGiftForm = () => {
	let categoryGiftForm = document.getElementById('eshopGifts_categoryGiftForm');

	if (!categoryGiftForm || categoryGiftForm.classList.contains('init'))
		return;

	categoryGiftForm.classList.add('init');
	let inputId = 'categoryGiftForm_product';
	let input = document.getElementById(inputId);
	let inputValue = categoryGiftForm.querySelector('[name="productId"]');
	let inputName = categoryGiftForm.querySelector('[name="name"]');
	let lastXhr;

	input.parentElement.style.position = 'relative';

	const dataLoader = new autoComplete({
		data: {
			src: () => {
				if (categoryGiftFormDataLoaded)
					return categoryGiftFormDataLoaded;

				if (typeof lastXhr !== 'undefined' && lastXhr.hasOwnProperty('abort'))
					lastXhr.abort();

				lastXhr = global.naja.makeRequest('get', input.getAttribute('data-link'), [], {
					history: false,
				}).then(e => {
					lastXhr = undefined;
					categoryGiftFormDataLoaded = Object.keys(e).map(i => e[i]);
					console.log(categoryGiftFormDataLoaded);

					return categoryGiftFormDataLoaded;
				});

				return lastXhr;
			},
			key: ['code1', 'name', 'ean'],
			cache: true,
		},
		cache: false,
		selector: '#' + inputId,
		maxResults: 20,
		threshold: 2,
		resultsList: {
			render: true,
			destination: input,
			position: "afterend",
			element: "ul"
		},
		resultItem: {
			content: (data, source) => {
				source.innerHTML = data.value.code1 + ' | ' + data.value.name;
			},
			element: "li"
		},
		onSelection: feedback => {
			inputValue.value = feedback.selection.value.id;
			input.value = feedback.selection.value.code1 + ' | ' + feedback.selection.value.name;
			inputName.value = feedback.selection.value.name;
		}
	});


	// let productsMap = {};
	//
	// let productFinder2 = () => {
	// 	return function findMatches(query, callbackSync, callback) {
	// 		// $.nette.ajax({
	// 		// 	url: input.dataset.link,
	// 		// 	data: {
	// 		// 		'categoryGiftForm-term': query
	// 		// 	},
	// 		// 	async: true,
	// 		// 	success: function (data) {
	// 		// 		let matches = [];
	// 		// 		$.each(data, function (idx, product) {
	// 		// 			productsMap[product.name] = product;
	// 		// 			matches.push(product.name)
	// 		// 		});
	// 		// 		callback(matches);
	// 		// 	}
	// 		// });
	// 	};
	// };
	//
	// input.typeahead({
	// 		hint: false,
	// 		highlight: true,
	// 		minLength: 3
	// 	},
	// 	{
	// 		name: 'states',
	// 		limit: 100,
	// 		source: productFinder2()
	//
	// 	}).bind('typeahead:select', function (ev, suggestion) {
	// 	console.log(productsMap[suggestion]);
	// 	// $('input[name="productId"]').val(productsMap[suggestion].id);
	// 	// $('input[name="code1"]').val(productsMap[suggestion].code1);
	// 	// $('input[name="price"]').val(productsMap[suggestion].price);
	// 	// $('input[name="vatRate"]').val(productsMap[suggestion].vatRate);
	// });
};
