<?php declare(strict_types = 1);

namespace EshopGifts\FrontModule\Model;

use EshopCatalog\FrontModule\Model\Dao\Category;
use Core\Model\Helpers\BaseFrontEntityService;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use EshopGifts\FrontModule\Model\Dao\Gift;
use EshopGifts\Model\Entities\CategoryGift;
use Nette\Utils\DateTime;
use EshopGifts\FrontModule\Model\Dao;

class CategoryGifts extends BaseFrontEntityService
{
	/** @var string */
	protected $entityClass = CategoryGift::class;

	/** @var Gift[] */
	protected $cGifts;

	/** @var ProductsFacade */
	protected $productsFacade;

	public function __construct(ProductsFacade $productsFacade)
	{
		$this->productsFacade = $productsFacade;
	}

	/**
	 * @param float $price
	 * @param array $categories
	 *
	 * @return Dao\Gift[]
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 * @throws \Nette\Application\UI\InvalidLinkException
	 * @throws \Throwable
	 */
	public function findGifts(float $price, array $categories): array
	{
		$result     = [];
		$productIds = [];
		$tmp        = [];

		foreach ($categories as $k => $v) {
			if ($v == null)
				unset($categories[$k]);
			else if ($v instanceof Category)
				$categories[$k] = $v->getId();
		}

		foreach ($this->getAll() as $row) {
			if (($price >= $row['priceFrom'] || $row['priceFrom'] === null)
				&& ($price <= $row['priceTo'] || $row['priceTo'] === null)
				&& (empty($categories) || array_intersect($categories, $row['categories']))
			) {
				$productIds[] = $row['product'];
				$tmp[]        = $row;
			}
		}

		$products = $this->productsFacade->getProducts($productIds);
		foreach ($tmp as $row) {
			if ($products[$row['product']])
				$result[] = new Dao\Gift($products[$row['product']], $row['name'], $row['description']);
		}

		return $result;
	}

	public function getAll(): array
	{
		if ($this->cGifts === null) {
			$this->cGifts = [];
			$today        = (new DateTime())->setTime(0, 0, 0);
			foreach ($this->getEr()->createQueryBuilder('g')
				         ->addSelect('GROUP_CONCAT(cats.id) as categories, IDENTITY(g.gift) as product')
				         ->innerJoin('g.categories', 'cats')
				         ->where('g.dateFrom <= :today OR g.dateFrom IS NULL')
				         ->andWhere('g.dateTo >= :today OR g.dateTo IS NULL')
				         ->andWhere('g.isActive = 1')
				         ->setParameters([
					         'today' => $today,
				         ])
				         ->groupBy('g.id')
				         ->getQuery()->useResultCache(true, 60)->getArrayResult() as $oRow) {
				$row            = $oRow[0];
				$this->cGifts[] = [
					'product'     => (int) $oRow['product'],
					'name'        => $row['name'] ?: null,
					'description' => $row['description'] ?: null,
					'priceFrom'   => $row['priceFrom'] ? (float) $row['priceFrom'] : null,
					'priceTo'     => $row['priceTo'] ? (float) $row['priceTo'] : null,
					'categories'  => explode(',', $oRow['categories']),
				];
			}
		}

		return $this->cGifts;
	}
}
