<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopGifts\Model\Entities\CategoryGift;
use Nette\Localization\ITranslator;

/**
 * Class CategoryGifts
 * @package EshopGifts\AdminModule\Model
 *
 * @method CategoryGift|object|null getReference($id)
 * @method CategoryGift[]|null getAll()
 */
class CategoryGifts extends BaseEntityService
{
	protected $entityClass = CategoryGift::class;

	/** @var ITranslator */
	protected $translator;

	public function __construct(ITranslator $translator)
	{
		$this->translator = $translator;
	}

	public function get($id): ?CategoryGift
	{
		return $this->getEr()->createQueryBuilder('g')
			->addSelect('p, pt')
			->where('g.id = :id')
			->innerJoin('g.gift', 'p')
			->leftJoin('p.productTexts', 'pt')
			->setParameters([
				'id' => $id,
			])->getQuery()->getOneOrNullResult();
	}
}
