if (!global.document.autocompleteResultItem) {
	global.document.autocompleteResultItem = {};
}

global.document.autocompleteResultItem['eshopGiftsGiftForm'] = (data, source) => {
	let str = data.value.code1 + ' | ';

	if (data.value.manufacturer) {
		str += data.value.manufacturer + ' - ';
	}

	str += data.value.name;

	source.innerHTML = str;
};

document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name === "eshopGiftsGiftForm") {
		let inputId          = 'categoryGiftForm_product';
		let input            = document.getElementById(inputId);
		let categoryGiftForm = input.closest('form');
		let inputValue       = categoryGiftForm.querySelector('[name="productId"]');
		let inputName        = categoryGiftForm.querySelectorAll('[name*="name"]');

		inputValue.value = e.detail.selection.value.id;
		input.value      = e.detail.selection.value.code1 + ' | ' + e.detail.selection.value.name;
		inputName.forEach(el => {
			if (e.detail.selection.value.texts[el.dataset.contentLang]) {
				el.value = e.detail.selection.value.texts[el.dataset.contentLang];
			} else {
				el.value = '';
			}
		});
	}
})
