<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TActive;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\Query\Parameter;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopGifts\Model\Entities\CategoryGift;
use Nette\Caching\Cache;
use Override;

/**
 * @method CategoryGift|object|null getReference($id)
 * @method CategoryGift[]|null getAll()
 */
class CategoryGifts extends BaseEntityService
{
	use TActive;

	protected $entityClass = CategoryGift::class;

	public function __construct(
		protected Translator   $translator,
		protected CacheService $cacheService,
	)
	{
	}

	/**
	 * @param int|string $id
	 *
	 * @throws NonUniqueResultException
	 */
	#[Override]
	public function get($id): ?CategoryGift
	{
		/** @var CategoryGift|null */
		return $this->getEr()->createQueryBuilder('cg')
			->addSelect('gift')
			->where('cg.id = :id')
			->innerJoin('cg.gift', 'gift')
			->setParameters(new ArrayCollection([new Parameter('id', $id)]))->getQuery()->getOneOrNullResult();
	}

	/**
	 * @param int|string $id
	 *
	 * @return bool
	 */
	#[Override]
	public function remove($id)
	{
		$result = parent::remove($id);

		if ($result) {
			$this->cacheService->defaultCache->remove('categoryGiftsAll');
			$this->cacheService->defaultCache->clean([
				Cache::Tags => 'gifts',
			]);
		}

		return $result;
	}
}
