<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TActive;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\Query\Parameter;
use EshopGifts\Model\Entities\ProductGift;
use Override;

/**
 * @method ProductGift|null getReference($id)
 * @method ProductGift[] getAll()
 */
class ProductGifts extends BaseEntityService
{
	use TActive;

	protected $entityClass = ProductGift::class;

	public function __construct(
		protected Translator $translator,
	)
	{
	}

	/**
	 * @param string|int $id
	 *
	 * @throws NonUniqueResultException
	 */
	#[Override]
	public function get($id): ?ProductGift
	{
		/** @var ProductGift|null */
		return $this->getEr()->createQueryBuilder('og')
			->addSelect('gift')
			->where('og.id = :id')
			->innerJoin('og.gift', 'gift')
			->setParameters(new ArrayCollection([new Parameter('id', $id)]))->getQuery()->getOneOrNullResult();
	}

	/**
	 * @return ProductGift[]
	 */
	public function getByProduct(int $productId): array
	{
		$result = [];

		foreach ((array) $this->getEr()->createQueryBuilder('pg')
			->addSelect('g')
			->where('pg.product = :product')
			->innerJoin('pg.gift', 'g')
			->setParameters(new ArrayCollection([new Parameter('product', $productId)]))->getQuery()->getResult() as $row) {
			/** @var ProductGift $row */
			$result[$row->getGift()->getId()] = $row;
		}

		return $result;
	}
}
