<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Presenters;

use EshopGifts\AdminModule\Components\CategoryGiftsGrid;
use EshopGifts\AdminModule\Components\GiftsGrid;
use EshopGifts\AdminModule\Components\ICategoryGiftsGridFactory;
use EshopGifts\AdminModule\Components\IGiftsGridFactory;
use EshopGifts\AdminModule\Components\IOrderGiftsGridFactory;
use EshopGifts\AdminModule\Components\OrderGiftsGrid;
use Override;

class DefaultPresenter extends BasePresenter
{
	protected const ICON = 'fas fa-gift';

	/**
	 * @return void
	 */
	#[Override]
	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopGifts.title.gifts', self::ICON);
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopGifts.menu.newGift',
				'link'  => $this->link('giftsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			], [
				'title' => 'eshopGifts.menu.newCategoryGift',
				'link'  => $this->link('categoryGiftsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			], [
				'title' => 'eshopGifts.menu.newOrderGift',
				'link'  => $this->link('orderGiftsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentGiftsGrid(IGiftsGridFactory $factory): GiftsGrid
	{
		return $factory->create();
	}

	protected function createComponentCategoryGiftsGrid(ICategoryGiftsGridFactory $factory): CategoryGiftsGrid
	{
		return $factory->create();
	}

	protected function createComponentOrderGiftsGrid(IOrderGiftsGridFactory $factory): OrderGiftsGrid
	{
		return $factory->create();
	}

}
