<?php declare(strict_types = 1);

namespace EshopGifts\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Override;

class EshopGiftsExtension extends CompilerExtension
{

	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['EshopGifts' => 'EshopGifts\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');

		$init->addBody('EshopGifts\Model\EshopGiftsConfig::setParams($this->parameters[\'eshopGifts\']);');
	}

}
