<?php declare(strict_types = 1);

namespace EshopGifts\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Doctrine\ORM\NonUniqueResultException;
use EshopGifts\Model\Entities\ProductGift;
use Nette\Application\UI\InvalidLinkException;
use Nette\Utils\DateTime;
use Throwable;

class ProductGifts extends BaseFrontEntityService
{
	/** @var string */
	protected $entityClass = ProductGift::class;

	/** @var int[][]|null */
	protected ?array $cGifts = null;

	public function __construct(
		protected Gifts $giftsService,
	)
	{
	}

	/**
	 *
	 * @return Dao\Gift[]
	 * @throws NonUniqueResultException
	 * @throws InvalidLinkException
	 * @throws Throwable
	 */
	public function findGifts(int $productId): array
	{
		$giftIds = $this->getAll()[$productId] ?? null;
		$result  = [];

		foreach ($giftIds ? $this->giftsService->getByIds($giftIds) : [] as $gift) {
			$gift->addOrigin        = 'product';
			$result[$gift->getId()] = $gift;
		}

		return $result;
	}

	public function getAll(): array
	{
		if ($this->cGifts === null) {
			$this->cGifts = [];

			foreach ($this->em->getConnection()->fetchAllAssociative("SELECT pg.gift_id, pg.product_id 
					FROM eshop_gifts__product_gift pg
					WHERE pg.date_from <= :today OR pg.date_from IS NULL
					AND pg.date_to >= :today OR pg.date_to IS NULL
					AND pg.is_active = 1", [
				'today' => (new DateTime())->format('Y-m-d') . ' 00:00:00',
			]) as $row) {
				/** @var array $row */
				$this->cGifts[(int) $row['product_id']][] = (int) $row['gift_id'];
			}
		}

		return $this->cGifts;
	}
}
