<?php declare(strict_types = 1);

namespace EshopGifts\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200119163848 extends AbstractMigration
{
	protected static array $gifts    = [];
	protected static array $giftsCat = [];

	#[Override]
	public function up(Schema $schema): void
	{
		self::$gifts    = $this->connection->fetchAllAssociative("SELECT * FROM eshop_gifts__category_gift");
		self::$giftsCat = $this->connection->fetchAllAssociative("SELECT * FROM eshop_gifts__category_gifts");

		$this->addSql('ALTER TABLE eshop_gifts__category_gift DROP FOREIGN KEY FK_D4BAF63797A95A83');
		$this->addSql('ALTER TABLE eshop_gifts__category_gifts DROP FOREIGN KEY FK_A367D0F297A95A83');
		$this->addSql('TRUNCATE TABLE eshop_gifts__category_gifts');
		$this->addSql('TRUNCATE TABLE eshop_gifts__category_gift');
		$this->addSql('CREATE TABLE eshop_gifts__gift (id INT AUTO_INCREMENT NOT NULL, product_id INT NOT NULL, name VARCHAR(255) DEFAULT NULL, description VARCHAR(255) DEFAULT NULL, is_active SMALLINT DEFAULT 1 NOT NULL, INDEX IDX_57B2E34C4584665A (product_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_gifts__order_gift (id INT AUTO_INCREMENT NOT NULL, gift_id INT NOT NULL, price_from NUMERIC(10, 2) DEFAULT NULL, price_to NUMERIC(10, 2) DEFAULT NULL, date_from DATETIME DEFAULT NULL, date_to DATETIME DEFAULT NULL, is_active SMALLINT DEFAULT 1 NOT NULL, INDEX IDX_BFFBD60197A95A83 (gift_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_gifts__product_gift (id INT AUTO_INCREMENT NOT NULL, gift_id INT NOT NULL, product_id INT DEFAULT NULL, date_from DATETIME DEFAULT NULL, date_to DATETIME DEFAULT NULL, is_active SMALLINT DEFAULT 1 NOT NULL, INDEX IDX_A0CDA3F397A95A83 (gift_id), INDEX IDX_A0CDA3F34584665A (product_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_gifts__gift ADD CONSTRAINT FK_57B2E34C4584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_gifts__order_gift ADD CONSTRAINT FK_BFFBD60197A95A83 FOREIGN KEY (gift_id) REFERENCES eshop_gifts__gift (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_gifts__product_gift ADD CONSTRAINT FK_A0CDA3F397A95A83 FOREIGN KEY (gift_id) REFERENCES eshop_gifts__gift (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_gifts__product_gift ADD CONSTRAINT FK_A0CDA3F34584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_gifts__category_gift DROP name, DROP description');
		$this->addSql('ALTER TABLE eshop_gifts__category_gift ADD CONSTRAINT FK_D4BAF63797A95A83 FOREIGN KEY (gift_id) REFERENCES eshop_gifts__gift (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_gifts__category_gifts ADD CONSTRAINT FK_A367D0F297A95A83 FOREIGN KEY (gift_id) REFERENCES eshop_gifts__category_gift (id)');

		$this->addSql('ALTER TABLE eshop_gifts__category_gifts DROP FOREIGN KEY FK_A367D0F212469DE2');
		$this->addSql('ALTER TABLE eshop_gifts__category_gifts DROP FOREIGN KEY FK_A367D0F297A95A83');
		$this->addSql('ALTER TABLE eshop_gifts__category_gifts ADD CONSTRAINT FK_A367D0F212469DE2 FOREIGN KEY (category_id) REFERENCES eshop_catalog__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_gifts__category_gifts ADD CONSTRAINT FK_A367D0F297A95A83 FOREIGN KEY (gift_id) REFERENCES eshop_gifts__category_gift (id) ON DELETE CASCADE');

		$this->addSql('CREATE TABLE eshop_gifts__order_gifts (gift_id INT NOT NULL, site_id VARCHAR(255) NOT NULL, INDEX IDX_6CB6044B97A95A83 (gift_id), INDEX IDX_6CB6044BF6BD1646 (site_id), PRIMARY KEY(gift_id, site_id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_gifts__order_gifts ADD CONSTRAINT FK_6CB6044B97A95A83 FOREIGN KEY (gift_id) REFERENCES eshop_gifts__order_gift (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_gifts__order_gifts ADD CONSTRAINT FK_6CB6044BF6BD1646 FOREIGN KEY (site_id) REFERENCES core__site (ident) ON DELETE CASCADE');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		foreach (self::$gifts as $gift) {
			$this->connection->insert('eshop_gifts__gift', [
				'product_id'  => $gift['gift_id'],
				'name'        => $gift['name'],
				'description' => $gift['description'],
				'is_active'   => $gift['is_active'],
			]);
			$giftId = $this->connection->lastInsertId();

			$this->connection->insert('eshop_gifts__category_gift', [
				'gift_id'    => $giftId,
				'price_from' => $gift['price_from'],
				'price_to'   => $gift['price_to'],
				'date_from'  => $gift['date_from'],
				'date_to'    => $gift['date_to'],
				'is_active'  => $gift['is_active'],
			]);
			$categoryGiftId = $this->connection->lastInsertId();

			foreach (self::$giftsCat as $cat) {
				if ($cat['gift_id'] != $gift['id']) {
					continue;
				}

				$this->connection->insert('eshop_gifts__category_gifts', [
					'gift_id'     => $categoryGiftId,
					'category_id' => $cat['category_id'],
				]);
			}
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE eshop_gifts__order_gifts');
		$this->addSql('ALTER TABLE eshop_gifts__category_gift DROP FOREIGN KEY FK_D4BAF63797A95A83');
		$this->addSql('ALTER TABLE eshop_gifts__order_gift DROP FOREIGN KEY FK_BFFBD60197A95A83');
		$this->addSql('ALTER TABLE eshop_gifts__product_gift DROP FOREIGN KEY FK_A0CDA3F397A95A83');
		$this->addSql('DROP TABLE eshop_gifts__gift');
		$this->addSql('DROP TABLE eshop_gifts__order_gift');
		$this->addSql('DROP TABLE eshop_gifts__product_gift');
		$this->addSql('ALTER TABLE eshop_gifts__category_gift DROP FOREIGN KEY FK_D4BAF63797A95A83');
		$this->addSql('ALTER TABLE eshop_gifts__category_gift ADD name VARCHAR(255) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`, ADD description VARCHAR(255) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`');
		$this->addSql('ALTER TABLE eshop_gifts__category_gift ADD CONSTRAINT FK_D4BAF63797A95A83 FOREIGN KEY (gift_id) REFERENCES eshop_catalog__product (id) ON UPDATE NO ACTION ON DELETE CASCADE');
	}
}
