<?php declare(strict_types = 1);

namespace EshopGifts\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200503191706 extends AbstractMigration
{
	protected static array $texts = [];

	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		foreach ($this->connection->fetchAllAssociative("SELECT id, name, description FROM eshop_gifts__gift") as $row) {
			self::$texts[] = $row;
		}

		$this->addSql('CREATE TABLE eshop_gifts__gift_text (gift_id INT NOT NULL, lang VARCHAR(2) NOT NULL, name VARCHAR(255) DEFAULT NULL, description VARCHAR(255) DEFAULT NULL, INDEX IDX_C476DAF97A95A83 (gift_id), PRIMARY KEY(gift_id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_gifts__gift_text ADD CONSTRAINT FK_C476DAF97A95A83 FOREIGN KEY (gift_id) REFERENCES eshop_gifts__gift (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_gifts__gift DROP name, DROP description');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		foreach (self::$texts as $row) {
			$this->connection->insert('eshop_gifts__gift_text', [
				'gift_id'     => $row['id'],
				'name'        => $row['name'],
				'description' => $row['description'],
				'lang'        => 'cs',
			]);
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE eshop_gifts__gift_text');
		$this->addSql('ALTER TABLE eshop_gifts__gift ADD name VARCHAR(255) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`, ADD description VARCHAR(255) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`');
	}
}
