<?php declare(strict_types = 1);

namespace EshopGifts\Model\Entities;

use DateTime;
use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Category;

#[ORM\Table('eshop_gifts__category_gift')]
#[ORM\Entity]
class CategoryGift
{
	use TId;

	#[ORM\JoinColumn(name: 'gift_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Gift::class)]
	protected Gift $gift;

	/** @var Collection<Category> */
	#[ORM\JoinTable(name: 'eshop_gifts__category_gifts')]
	#[ORM\JoinColumn(name: 'gift_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\InverseJoinColumn(name: 'category_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToMany(targetEntity: Category::class)]
	protected Collection $categories;

	/**
	 * @var double|null
	 */
	#[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
	public $priceFrom;

	/**
	 * @var double|null
	 */
	#[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
	public $priceTo;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $dateFrom = null;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $dateTo = null;

	#[ORM\Column(type: Types::SMALLINT, length: 1, options: ['default' => 1])]
	protected int $isActive = 1;

	public function __construct(Gift $gift)
	{
		$this->setGift($gift);
		$this->categories = new ArrayCollection;
		$this->isActive   = 1;
	}

	public function getGift(): Gift { return $this->gift; }

	public function setGift(Gift $gift): self
	{
		$this->gift = $gift;

		return $this;
	}

	public function isActive(): int { return (int) $this->isActive; }

	/**
	 * @param int|bool $active
	 */
	public function setActive($active): self
	{
		$this->isActive = (int) $active;

		return $this;
	}

	/**
	 * @return Collection<Category>
	 */
	public function getCategories() { return $this->categories; }

	/**
	 * @param Category[] $categories
	 */
	public function setCategories(array $categories): self
	{
		$this->categories = new ArrayCollection($categories);

		return $this;
	}
}
