<?php declare(strict_types = 1);

namespace EshopGifts\Model\Entities;

use DateTime;
use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;

#[ORM\Table('eshop_gifts__product_gift')]
#[ORM\Entity]
class ProductGift
{
	use TId;

	#[ORM\JoinColumn(name: 'gift_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Gift::class)]
	protected Gift $gift;

	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Product::class)]
	protected Product $product;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $dateFrom = null;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $dateTo = null;

	#[ORM\Column(type: Types::SMALLINT, length: 1, options: ['default' => 1])]
	public int $isActive = 1;

	public function __construct(Gift $gift, Product $product)
	{
		$this->setGift($gift);
		$this->product  = $product;
		$this->isActive = 1;
	}

	public function getGift(): Gift { return $this->gift; }

	public function setGift(Gift $gift): self
	{
		$this->gift = $gift;

		return $this;
	}

	public function getProduct(): Product { return $this->product; }

	public function isActive(): int { return (int) $this->isActive; }

	/**
	 * @param bool|int $active
	 */
	public function setActive($active): self
	{
		$this->isActive = (int) $active;

		return $this;
	}

}
