<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TActive;
use Doctrine\ORM\NonUniqueResultException;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopGifts\Model\Entities\CategoryGift;
use Nette\Caching\Cache;
use Contributte\Translation\Translator;

/**
 * @method CategoryGift|object|null getReference($id)
 * @method CategoryGift[]|null getAll()
 */
class CategoryGifts extends BaseEntityService
{
	use TActive;

	protected $entityClass = CategoryGift::class;

	protected Translator   $translator;
	protected CacheService $cacheService;

	public function __construct(
		Translator   $translator,
		CacheService $cacheService
	)
	{
		$this->translator   = $translator;
		$this->cacheService = $cacheService;
	}

	/**
	 * @param int|string $id
	 *
	 * @throws NonUniqueResultException
	 */
	public function get($id): ?CategoryGift
	{
		return $this->getEr()->createQueryBuilder('cg')
			->addSelect('gift')
			->where('cg.id = :id')
			->innerJoin('cg.gift', 'gift')
			->setParameters([
				'id' => $id,
			])->getQuery()->getOneOrNullResult();
	}

	/**
	 * @param int|string $id
	 *
	 * @return bool
	 */
	public function remove($id)
	{
		$result = parent::remove($id);

		if ($result) {
			$this->cacheService->defaultCache->remove('categoryGiftsAll');
			$this->cacheService->defaultCache->clean([
				Cache::Tags => 'gifts',
			]);
		}

		return $result;
	}
}
