<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TActive;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopGifts\Model\Entities\Gift;
use Nette\Caching\Cache;
use Contributte\Translation\Translator;

/**
 * @method Gift|null getReference($id)
 * @method Gift|null get($id)
 */
class Gifts extends BaseEntityService
{
	use TActive;

	protected $entityClass = Gift::class;

	protected Translator   $translator;
	protected CacheService $cacheService;

	public function __construct(
		Translator   $translator,
		CacheService $cacheService
	)
	{
		$this->translator   = $translator;
		$this->cacheService = $cacheService;
	}

	/**
	 * @return Gift[]
	 */
	public function getAll()
	{
		return $this->getEr()->createQueryBuilder('g')
			->addSelect('gt')
			->innerJoin('g.texts', 'gt')
			->getQuery()->getResult();
	}

	/**
	 * @param int|string $id
	 * @return bool
	 */
	public function remove($id)
	{
		$result = parent::remove($id);

		if ($result) {
			$this->cacheService->defaultCache->remove('categoryGiftsAll');
			$this->cacheService->defaultCache->clean([
				Cache::Tags => 'gifts',
			]);
		}

		return $result;
	}
}
