<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TActive;
use Doctrine\ORM\NonUniqueResultException;
use EshopGifts\Model\Entities\OrderGift;

/**
 * @method OrderGift|null getReference($id)
 * @method OrderGift[] getAll()
 */
class OrderGifts extends BaseEntityService
{
	use TActive;

	protected $entityClass = OrderGift::class;
	protected Translator $translator;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	/**
	 * @param int|string $id
	 * @throws NonUniqueResultException
	 */
	public function get($id): ?OrderGift
	{
		return $this->getEr()->createQueryBuilder('og')
			->addSelect('gift')
			->where('og.id = :id')
			->innerJoin('og.gift', 'gift')
			->setParameters([
				'id' => $id,
			])->getQuery()->getOneOrNullResult();
	}
}
