<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TActive;
use Doctrine\ORM\NonUniqueResultException;
use EshopGifts\Model\Entities\ProductGift;

/**
 * @method ProductGift|null getReference($id)
 * @method ProductGift[] getAll()
 */
class ProductGifts extends BaseEntityService
{
	use TActive;

	protected $entityClass = ProductGift::class;
	protected Translator $translator;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	/**
	 * @param string|int $id
	 * @throws NonUniqueResultException
	 */
	public function get($id): ?ProductGift
	{
		return $this->getEr()->createQueryBuilder('og')
			->addSelect('gift')
			->where('og.id = :id')
			->innerJoin('og.gift', 'gift')
			->setParameters([
				'id' => $id,
			])->getQuery()->getOneOrNullResult();
	}

	/**
	 * @param int $productId
	 * @return ProductGift[]
	 */
	public function getByProduct(int $productId): array
	{
		$result = [];

		foreach ($this->getEr()->createQueryBuilder('pg')
			         ->addSelect('g')
			         ->where('pg.product = :product')
			         ->innerJoin('pg.gift', 'g')
			         ->setParameters([
				         'product' => $productId,
			         ])->getQuery()->getResult() as $row) {
			$result[$row->getGift()->getId()] = $row;
		}

		return $result;
	}
}
