<?php declare(strict_types = 1);

namespace EshopGifts\DI;

use Core\DI\CompilerExtension;
use Nette;

class EshopGiftsExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopGifts' => 'EshopGifts\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('EshopGifts\Model\EshopGiftsConfig::setParams($this->parameters[\'eshopGifts\']);');
	}

}
