<?php declare(strict_types = 1);

namespace EshopGifts\FrontModule\Model\Dao;

use EshopCatalog\FrontModule\Model\Dao\Product;

class Gift
{
	/** @var int */
	protected $id;

	/** @var Product */
	protected $product;

	/** @var string */
	protected $name;

	/** @var string */
	protected $description;

	/** @var string */
	public $code1;

	/** @var string */
	public $ean;

	/** @var string */
	public $addOrigin;

	/** @var string|double|null */
	public $priceFrom = null;

	public function __construct(int $id, Product $product, ?string $name = null, ?string $description = null)
	{
		$this->id          = $id;
		$this->product     = $product;
		$this->name        = $name ?: $product->getName();
		$this->description = $description ?: $product->shortDescription;
	}

	public function getId(): int { return $this->id; }

	public function getProduct(): Product { return $this->product; }

	public function getName(): string { return $this->name; }

	public function getDescription(): string { return $this->description; }
}
