<?php declare(strict_types = 1);

namespace EshopGifts\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use EshopGifts\Model\Entities\ProductGift;
use Nette\Utils\DateTime;
use EshopGifts\FrontModule\Model\Dao;

class ProductGifts extends BaseFrontEntityService
{
	/** @var string */
	protected $entityClass = ProductGift::class;

	/** @var Dao\Gift[] */
	protected $cGifts;

	/** @var Gifts */
	protected $giftsService;

	public function __construct(Gifts $gifts)
	{
		$this->giftsService = $gifts;
	}

	/**
	 * @param int $productId
	 *
	 * @return Dao\Gift[]
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 * @throws \Nette\Application\UI\InvalidLinkException
	 * @throws \Throwable
	 */
	public function findGifts(int $productId): array
	{
		$giftIds = $this->getAll()[$productId] ?? null;
		$result  = [];

		foreach ($giftIds ? $this->giftsService->getByIds($giftIds) : [] as $gift) {
			$gift->addOrigin        = 'product';
			$result[$gift->getId()] = $gift;
		}

		return $result;
	}

	public function getAll(): array
	{
		if ($this->cGifts === null) {
			$this->cGifts = [];
			$today        = (new DateTime())->setTime(0, 0, 0);
			foreach ($this->getEr()->createQueryBuilder('pg')
				         ->select('IDENTITY(pg.gift) as gift, IDENTITY(pg.product) as product')
				         ->where('pg.dateFrom <= :today OR pg.dateFrom IS NULL')
				         ->andWhere('pg.dateTo >= :today OR pg.dateTo IS NULL')
				         ->andWhere('pg.isActive = 1')
				         ->setParameters([
					         'today' => $today,
				         ])
				         ->getQuery()->getArrayResult() as $row) {
				$this->cGifts[$row['product']][] = (int) $row['gift'];
			}
		}

		return $this->cGifts;
	}
}
